<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>@yield('title','Admin Panel')</title>

    <link rel="icon" href="{{ asset('assets/images/favicon-icon.png') }}" type="image/x-icon">
    <link rel="stylesheet" href="{{ asset('assets/json/fonts/inter/inter.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/json/fonts/tabler-icons.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/json/fonts/feather.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/json/fonts/fontawesome.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/json/fonts/material.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}" id="main-style-link">
    <link rel="stylesheet" href="{{ asset('assets/css/style-preset.css') }}">

    @stack('css')
</head>

<body data-pc-preset="preset-1" data-pc-sidebar-caption="true" data-pc-direction="ltr" data-pc-theme_contrast=""
    data-pc-theme="light">
    @include('partials.sidebar')
    @include('partials.header')
    <div class="pc-container">
        <div class="pc-content">
            @yield('content')
        </div>
    </div>

    <!-- JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="{{ asset('assets/js/plugins/popper.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/simplebar.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/fonts/custom-font.js') }}"></script>
    <script src="{{ asset('assets/js/pcoded.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/feather.min.js') }}"></script>
    @stack('scripts')
</body>

</html>