@extends('layouts.admin')

@section('title', 'Item Master')

@push('css')
    <link rel="stylesheet" href="{{ asset('assets/css/plugins/dataTables.bootstrap5.min.css') }}">
    <style>
        .file-upload-wrapper {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }
        .file-upload-wrapper input[type="file"] {
            flex: 1;
            width: 250px;
        }
        .file-upload-wrapper button {
            white-space: nowrap;
        }
    </style>
@endpush

@section('content')
@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

@if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
<div id="loaderOverlay" style="display: none;position: fixed;top: 0; left: 0;width: 100%; height: 100%;background: rgba(255, 255, 255, 0.8);z-index: 9999;text-align: center;padding-top: 200px;">
    <div class="spinner-border text-primary" role="status" style="width: 4rem; height: 4rem;">
        <span class="visually-hidden">Loading...</span>
    </div>
    <div class="mt-3">
        <strong>Generating DB, please wait...</strong>
    </div>
</div>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
        <div class="d-flex align-items-center gap-3">
            <h3>Item Master</h3>
            <!-- Refresh Button -->
            <button id="refreshTable" class="btn btn-primary">Refresh</button>
        </div>
        <div class="d-flex align-items-center gap-2">
            <!-- Upload Form -->
            <form id="exportForm" enctype="multipart/form-data" class="file-upload-wrapper mb-0">
                @csrf
                <input type="file" name="sqlite_file" accept=".sqlite,.db" class="form-control" required>
                <button type="submit" class="btn btn-success">Generate DB(item master)</button>
            </form>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="itemMasterTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Item Code</th>
                        <th>Description</th>
                        <th>UOM</th>
                        <th>Item No</th>
                        <th>ConvFactor</th>
                        <th>Base UOM</th>
                        <th>Business Unit</th>
                        <th>Company ID</th>
                        <th>Is Weighed Item</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('assets/js/plugins/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/dataTables.bootstrap5.min.js') }}"></script>
<script>
$(document).ready(function () {
    let table = $('#itemMasterTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('admin.items.index') }}",
        columns: [
            { data: 'ItemCode', name: 'ItemCode' },
            { data: 'Description', name: 'Description' },
            { data: 'UOM', name: 'UOM' },
            { data: 'Item_No', name: 'Item_No' },
            { data: 'ConvFactor', name: 'ConvFactor' },
            { data: 'Base_UOM', name: 'Base_UOM' },
            { data: 'BusinessUnitid', name: 'BusinessUnitid' },
            { data: 'CompanyId', name: 'CompanyId' },
            {
                data: 'IsWeightedItem',
                name: 'IsWeightedItem',
                render: function (data, type, row) {
                    return data === 1 ? 'Yes' : 'No';
                }
            }
        ]
    });

    $('#refreshTable').on('click', function () {
        table.ajax.reload();
    });

    $('#exportForm').on('submit', function(e) {
        e.preventDefault();

        var form = $(this)[0];
        var formData = new FormData(form);
        var uploadedFile = $(form).find('input[name="sqlite_file"]')[0].files[0];
        var originalName = uploadedFile ? uploadedFile.name : 'ItemMaster.sqlite';
        var downloadName = originalName.replace(/\.(sqlite|db|sqlite3)$/i, '.sqlite');

        // Show loader
        $('#loaderOverlay').show();

        $.ajax({
            url: "{{ route('admin.items.export') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            xhrFields: {
                responseType: 'blob' // important for binary files
            },
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(blob) {
                var url = window.URL.createObjectURL(blob);
                var a = document.createElement('a');
                a.href = url;
                a.download = downloadName;
                document.body.appendChild(a);
                a.click();
                a.remove();
                window.URL.revokeObjectURL(url);
                $('#loaderOverlay').hide();
            },
            error: function(xhr, status, error) {
                $('#loaderOverlay').hide();
                alert('Export failed: ' + error);
                //location.reload();
            }
        });
    });

});
</script>
@endpush
