<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('item_masters', function (Blueprint $table) {
            $table->id();
            $table->string('ItemCode')->unique();
            $table->text('Description')->nullable();
            $table->string('UOM')->nullable();
            $table->decimal('Price', 15, 2)->nullable();
            $table->decimal('Cost', 15, 2)->nullable();
            $table->integer('Inventory')->nullable();
            $table->integer('QtyInPO')->nullable();
            $table->integer('QtyInSO')->nullable();
            $table->integer('QtyInTO')->nullable();
            $table->string('Item_No')->nullable();
            $table->string('VariantCode')->nullable();
            $table->integer('QtyinTransferIn')->nullable();
            $table->integer('QtyinTransferOut')->nullable();
            $table->string('ConvFactor', 10, 2)->nullable();
            $table->string('Base_UOM')->nullable();
            $table->string('BusinessUnitid')->nullable();
            $table->string('CompanyId')->nullable();
            $table->enum('action_flag', ['is_add', 'is_edit', 'is_delete'])
              ->default('is_add')
              ->comment('Tracks if record is added, edited, or deleted');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('item_masters');
    }
};
