<?php

namespace App\Http\Middleware;

use App\Models\ApiToken;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ValidateApiToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
       $token = $request->header('X-API-TOKEN');

        if (!$token) {
            return response()->json(['isSuccess' => false, 'message' => 'Token missing'], 401);
        }

        $apiToken = ApiToken::where('token', $token)->first();
        if (!$apiToken || Carbon::parse($apiToken->expires_at)->isPast()) {
            return response()->json(['isSuccess' => false, 'message' => 'Token expired or invalid'], 401);
        }

        return $next($request);
    }
}
